/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.iprinewsanalyzer;

import data.structures.rss.Tag;
import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.RSSFeedDatabase;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/**
 *
 * @author Utilisateur
 */
public class PanelFlux extends JPanel {
    private FenetrePrincipale parent;
    private Map<Tag, JCheckBox> liste = new HashMap<Tag, JCheckBox>();

    public PanelFlux(FenetrePrincipale fp, Database bdd){
        this.parent = fp;
        try {
            RSSFeedDatabase rfd = new RSSFeedDatabase(bdd);

            setLayout(new GridLayout(1, 4, 0, 5));
            JPanel p1 = new JPanel();
            BoxLayout b1 = new BoxLayout(p1, BoxLayout.PAGE_AXIS);
            p1.setLayout(b1);
            Tag[] t = rfd.getTags(RSSFeedDatabase.TAGS_CATEGORIE);
            for(int i=0; i<t.length; i++){
                final Tag tt = t[i];
                JCheckBox c = new JCheckBox(t[i].getTag(), true);
                c.addActionListener(new ActionListener(){
                    public void actionPerformed(ActionEvent ae){
                        parent.changeTag();
                    }
                });
                p1.add(c);
                liste.put(tt, c);
            }
            add(p1);
            JPanel p2 = new JPanel();
            BoxLayout b2 = new BoxLayout(p2, BoxLayout.PAGE_AXIS);
            p2.setLayout(b2);
            t = rfd.getTags(RSSFeedDatabase.TAGS_PAYS);
            for(int i=0; i<t.length; i++){
                final Tag tt = t[i];
                JCheckBox c = new JCheckBox(t[i].getTag(), true);
                c.addActionListener(new ActionListener(){
                    public void actionPerformed(ActionEvent ae){
                        parent.changeTag();
                    }
                });
                p2.add(c);
                liste.put(tt, c);
            }
            add(p2);
            JPanel p3 = new JPanel();
            BoxLayout b3 = new BoxLayout(p3, BoxLayout.PAGE_AXIS);
            p3.setLayout(b3);
            t = rfd.getTags(RSSFeedDatabase.TAGS_COUVERTURE);
            for(int i=0; i<t.length; i++){
                final Tag tt = t[i];
                JCheckBox c = new JCheckBox(t[i].getTag(), true);
                c.addActionListener(new ActionListener(){
                    public void actionPerformed(ActionEvent ae){
                        parent.changeTag();
                    }
                });
                p3.add(c);
                liste.put(tt, c);
            }
            add(p3);
            JPanel p4 = new JPanel();
            BoxLayout b4 = new BoxLayout(p4, BoxLayout.PAGE_AXIS);
            p4.setLayout(b4);
            t = rfd.getTags(RSSFeedDatabase.TAGS_INFORMATION);
            for(int i=0; i<t.length; i++){
                final Tag tt = t[i];
                JCheckBox c = new JCheckBox(t[i].getTag(), true);
                c.addActionListener(new ActionListener(){
                    public void actionPerformed(ActionEvent ae){
                        parent.changeTag();
                    }
                });
                p4.add(c);
                liste.put(tt, c);
            }
            add(p4);
        } catch(NoBaseException nbe){
            setLayout(new BorderLayout());
            add(new JLabel("Base indisponible."));

        }
    }

    public Tag[] listeTagsAcceptes(){
        Vector<Tag> v = new Vector<Tag>(liste.keySet());
        Vector<Tag> v2 = new Vector<Tag>();
        for(int i=0; i<v.size(); i++){
            if(choisi(v.elementAt(i))){
                v2.addElement(v.elementAt(i));
            }
        }
        Tag[] res = new Tag[v2.size()];
        v2.toArray(res);
        return res;
    }

    private boolean choisi(Tag t){
        JCheckBox c = liste.get(t);
        if(c==null) {
            return false;
        } else {
            return c.isSelected();
        }
    }
}
